/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedEnumValue;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class CommonConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final CachedEnumValue<UnitDisplayUtils.EnergyUnit> energyUnit;
    public final CachedEnumValue<UnitDisplayUtils.TemperatureUnit> tempUnit;

    CommonConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Mekanism Common Config. This config is not sync'd between server and client.").push("common");
        this.energyUnit = CachedEnumValue.wrap((IMekanismConfig)this, builder.comment("Displayed energy type in Mekanism GUIs and network reader readings.").defineEnum("energyType", (Enum)UnitDisplayUtils.EnergyUnit.FORGE_ENERGY));
        this.tempUnit = CachedEnumValue.wrap((IMekanismConfig)this, builder.comment("Displayed temperature unit in Mekanism GUIs and network reader readings.").defineEnum("temperatureUnit", (Enum)UnitDisplayUtils.TemperatureUnit.KELVIN));
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "common";
    }

    @Override
    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.COMMON;
    }
}

